/*  COPYRIGHT INFORMATION:
This free script was written by Daniel Rodney - instructor, graphic designer, Adobe Certified Expert, Adobe Certified Instructor
No part of this script can be used and/or redistributed as your own. All rights are reserved by Daniel Rodney.
http://www.danrodney.com
dan@danrodney.com
Copyright Daniel Rodney 2004-2007

DESCRIPTION:
While OpenType fonts can "somewhat" automatically format fractions (such as 1/8) as proper fractions,
this script is meant to allow users that don't have OpenType fonts to still format proper fractions 
quickly and easily. I hope you find it useful and a time saver.

You can share this script with friends and associates as long as it does not involve posting 
it on a website or other medium where it can be downloaded/shared with many people. 
Any form of mass distribution is prohibited unless you obtain prior written consent. 
Please direct people to http://www.danrodney.com to download it.

Thanks Dan! If you find this "free" script valuable, please consider making a donation via PayPal. It will:
- Encourage me to write more free scripts.
- Make you (and me) feel warm and fuzzy inside.
- Be a great way to say thanks for the hours I spent writing a script that saved you some time and effort.
Just visit http://www.danrodney.com/scripts
Go to the Proper Fraction page and click the Make A Donation button. Thanks!

UPGRADE TO PRO VERSION:
If you like this script, you have to see the “Pro” Version! The “Pro” version includes everything in the free version plus 
these amazing features that make fractions look better in a fraction of the time!
• Automatically Format All Fractions in a File
• A Preferences Window
• Stroke Numerator and Denominator
• OpenType Support
• and more...
Visit http://www.danrodney.com/scripts to upgrade today!

COMPATIBILITY:
This script works on both Mac and PC. It has been tested in InDesign/InCopy CS3, CS2 and CS

INSTRUCTIONS - INSTALLING THE SCRIPT:
To install the script, put the script file (has a .js file extension) into the folder listed below. 
(InCopy installations are identical to InDesign, except the desired folder is titled InCopy.)

CS2 & CS: Mac-----------------------------------------------------------
Hard Drive > Applications > Adobe InDesign CS2 (or CS) > Presets > Scripts

CS2 & CS: Windows-----------------------------------------------------------
C:Drive > Program Files > Adobe > Adobe InDesign CS2 (or CS) > Presets > Scripts

CS3: Mac-----------------------------------------------------------
Hard Drive > Applications > Adobe InDesign CS3 > Scripts > Scripts Panel
or Hard Drive > Users > [username] > Library > Preferences > Adobe InDesign > Version 5.0 > Scripts > Scripts Panel

CS3: Windows XP-----------------------------------------------------------
C:Drive > Program Files > Adobe > Adobe InDesign CS3 > Scripts > Scripts Panel 
or C:Drive > Documents and Settings > [username] > Application Data > Adobe > InDesign > Version 5.0 > Scripts > Scripts Panel

CS3: Windows Vista-----------------------------------------------------------
C:Drive > Program Files > Adobe > Adobe InDesign CS3 > Scripts > Scripts Panel
or C:Drive > Users > [username] > AppData > Roaming > Adobe > InDesign > Version 5.0 > Scripts > Scripts Panel

INSTRUCTIONS - USING THE SCRIPT:
1. Select a fraction (such as 1/8).
2. Double-click this script's name in the Scripts palette.
          NOTE: To find the Scripts palette:
          In InDesign CS3 & CS2: Go into the Window menu and choose Automation > Scripts.
          In InDesign CS: Go into the Window menu and choose Scripting > Scripts.
That's it! I hope you enjoy... 

HINT: If using several fonts that need different kerning/size preferences, make copies of 
this script for each font. Customize each copy of the script for a particular font.

==================================================================================================
PREFERENCES:
Keep in mind that I refer to fractions as numerator/denominator                                                                   */

//Type Size: Horizontal & Vertical Scale to Be Precise (in %). Original size is 100%. Anything less will reduce the size.
myNumeratorVScale=55
myNumeratorHScale=55

mySlashVScale=100
mySlashHScale=100

myDenominatorVScale=55
myDenominatorHScale=55

//Baseline Shift (in %). Positive numbers shift up, negative numbers shift down
myNumeratorBShift=32
mySlashBShift=0
myDenominatorBShift=0

//Will the slash get converted into a proper fraction slash? (true or false)
useFractionSlash=true

//Change Kerning Type (Metrics or Optical)
//The default setting is 0 so it does not change the kerning type ( I do this to respect your kerning choice)
//You can change this to 1 for Optical or 2 for Metrics
myKerningType = 0

//Blanket Kerning Amount (in %). These do nothing when using the Custom Kerning Amounts below (which are turned on by default!)
myNumeratorKern=-40
myDenominatorKern=-40

//Custom Kerning (adjust kerning uniquely for each number before or after a slash instead of using the blanket kerning specified above)
//Set to true to use custom amounts, or false to ignore them and use the blanket amount above.
myUseCustomKerning=true

//Custom Kerning Amounts Before a Slash
myCustomBeforeSlashKerning0 = -40
myCustomBeforeSlashKerning1 = 0
myCustomBeforeSlashKerning2 = 60
myCustomBeforeSlashKerning3 = -75
myCustomBeforeSlashKerning4 = 65
myCustomBeforeSlashKerning5 = -170
myCustomBeforeSlashKerning6 = -10
myCustomBeforeSlashKerning7 = -300
myCustomBeforeSlashKerning8 = 0
myCustomBeforeSlashKerning9 = -170

//Custom Kerning Amounts After a Slash
myCustomAfterSlashKerning0 = 90
myCustomAfterSlashKerning1 = -125
myCustomAfterSlashKerning2 = 0
myCustomAfterSlashKerning3 = 0
myCustomAfterSlashKerning4 = -225
myCustomAfterSlashKerning5 = 0
myCustomAfterSlashKerning6 = -20
myCustomAfterSlashKerning7 = 150
myCustomAfterSlashKerning8 = 0
myCustomAfterSlashKerning9 = 0

//END OF PREFERENCES
//==================================================================================================
//START OF MAIN SCRIPT

//define function to reuse whenever they don't haven't selected a proper fraction
function myFractionNotSelectedAlert() {
	alert("Please select a fraction you want to style as proper fraction.\nScript written by Daniel Rodney - instructor, graphic designer\nwww.danrodney.com")
}

currentlyHasFractionSlash = false

if (app.documents.length == 0) //make sure a document is open
{
	//no documents are open, so display an error message
	alert("You don't have any InDesign documents open. Please open a document and select some text you want to style as a proper fraction.\nScript written by Daniel Rodney - instructor, graphic designer\nwww.danrodney.com")
}
else if (app.selection.length == 0) //make sure something is selected
{
	//nothing is selected, so display an error message
	myFractionNotSelectedAlert()
}
else if (app.selection[0].constructor.name == "Group" ) //make sure a group isn't selected
{
	//a group is selected, so display an error message
	myFractionNotSelectedAlert()
}
else if (app.selection[0].contents.length < 3) //make sure at least 3 letters are selected
{
	//less than three characters are selected, so display an error message
	myFractionNotSelectedAlert()
}
else if (app.selection[0].contents.length > 50) //make sure a huge amount of text isn't selected
{
	//too many characters are selected, so display an error message
	myFractionNotSelectedAlert()
}
else if (app.selection[0].characters.item(0).contents == "/" )  //check if the 1st character is a slash
{
	//the first character is a slash, so display an error message
	myFractionNotSelectedAlert()
}
else if (app.selection[0].characters.item(0).contents == "\u2044" ) //check if the 1st character is a FractionSlash by it's unicode value (works in ExtendScript Toolkit 2)
{
	//the first character is a FractionSlash, so display an error message
	myFractionNotSelectedAlert()
}
else if (app.selection[0].characters.item( (app.selection[0].contents.length - 1) ).contents == "/" )  //check if the last character is a slash
{
	//the last character is a slash, so display an error message
	myFractionNotSelectedAlert()
}
else if (app.selection[0].characters.item( (app.selection[0].contents.length - 1) ).contents == "\u2044" ) //check if the last character is a FractionSlash by it's unicode value (works in ExtendScript Toolkit 2)
{
	//the last character is a FractionSlash, so display an error message
	myFractionNotSelectedAlert()
}
else
{
	//make sure the text contains a slash or FractionSlash somewhere inside
	mySlashes = 0 //assume there is no slash (or FractionSlash) until proven otherwise
	for(i=0; i<app.selection[0].contents.length; i++)  //see how many slashes (or FractionSlashs) there are
	{
		if (app.selection[0].characters.item(i).contents == "/" )  //check for a regular slash
		{
			myFoundSlashSize = app.selection[0].characters.item(i).pointSize //find out the current size of the slash
			mySlashCharacterID = i  //record the character position of the slash so later I'll know when to stop formatting
			mySlashes = ++mySlashes
		}
		else if (app.selection[0].characters.item(i).contents == "\u2044" ) //check for a FractionSlash by it's unicode value (works in ExtendScript Toolkit 2)
		{
			myFoundSlashSize = app.selection[0].characters.item(i).pointSize  //find out the current size of the slash
			mySlashCharacterID = i  //record the character position of the FractionSlash so later I'll know when to stop formatting
			currentlyHasFractionSlash = true
			mySlashes = ++mySlashes
		}
	}
	
	if ( mySlashes != 1 ) //make sure one, and only one slash (or FractionSlash) is found
	{
		//a proper fraction is not selected so display an error message
		myFractionNotSelectedAlert()
	}
	else //a proper fraction is selected, so it can now be formatted
	{		
		//convert numerator/denominator baseline shift percentages to decimals
		myNumeratorBShift		= (myNumeratorBShift	/ 100)
		myDenominatorBShift	= (myDenominatorBShift	/ 100)
			
		//figure out how much to baseline shift the numerator/denominator
		myProperFractionNumeratorBaselineShift    = (myFoundSlashSize * myNumeratorBShift)
		myProperFractionDenominatorBaselineShift = (myFoundSlashSize * myDenominatorBShift)
		
		//change size and baseline shift of numerator characters (numbers before the slash)
		for(i=0; i < mySlashCharacterID; i++)
		{
			app.selection[0].characters.item(i).horizontalScale	= myNumeratorHScale
			app.selection[0].characters.item(i).verticalScale		= myNumeratorVScale
			app.selection[0].characters.item(i).baselineShift		= myProperFractionNumeratorBaselineShift
		}
		
		//change size and baseline shift of denominator characters (numbers after the slash)
		for(i=(mySlashCharacterID + 1); i<app.selection[0].contents.length; i++)
		{
			app.selection[0].characters.item(i).horizontalScale	= myDenominatorHScale
			app.selection[0].characters.item(i).verticalScale		= myDenominatorVScale
			app.selection[0].characters.item(i).baselineShift		= myProperFractionDenominatorBaselineShift
		}
		
		mySlashBShift = (mySlashBShift / 100)  //convert percent into decimal
		mySlashBaselineShift = (myFoundSlashSize * mySlashBShift) //calculate amount of baseline shift for the slash
		app.selection[0].characters.item(mySlashCharacterID).horizontalScale	= mySlashHScale //change the size of the slash
		app.selection[0].characters.item(mySlashCharacterID).verticalScale		= mySlashVScale //change the size of the slash
		app.selection[0].characters.item(mySlashCharacterID).baselineShift		= mySlashBaselineShift //change the baseline shift of the slash

		//change the slash to a FractionSlash if the user wants it
		if( (currentlyHasFractionSlash!=true) && (useFractionSlash == true) ) //make sure it doesn't already have a FractionSlash and the user wants to use a FractionSlash
		{
			app.selection[0].characters.item(mySlashCharacterID).contents = "\u2044" //inserts a PROPER FractionSlash via it's unicode value (this works with ExtendScript Toolkit 2)
		}
		
		//depending on preference, change the kerning method for all selected characters
		if(myKerningType == 1 )  { //set to optical kerning
			for(i=0; i<app.selection[0].contents.length; i++)  {
				app.selection[0].characters.item(i).kerningMethod = "Optical"
			}
		}
		else if(myKerningType == 2 )  { //set to metrics kerning
			for(i=0; i<app.selection[0].contents.length; i++)  {
				app.selection[0].characters.item(i).kerningMethod = "Metrics"
			}
		}

		//apply kerning
		if(myUseCustomKerning == true) {  //if custom kerning preference is selected, then calculate and apply custom kerning amount

		//convert percents into decimals	
		myCustomBeforeSlashKerning0 = (myCustomBeforeSlashKerning0 / 100)
		myCustomBeforeSlashKerning1 = (myCustomBeforeSlashKerning1 / 100)
		myCustomBeforeSlashKerning2 = (myCustomBeforeSlashKerning2 / 100)
		myCustomBeforeSlashKerning3 = (myCustomBeforeSlashKerning3 / 100)
		myCustomBeforeSlashKerning4 = (myCustomBeforeSlashKerning4 / 100)
		myCustomBeforeSlashKerning5 = (myCustomBeforeSlashKerning5 / 100)
		myCustomBeforeSlashKerning6 = (myCustomBeforeSlashKerning6 / 100)
		myCustomBeforeSlashKerning7 = (myCustomBeforeSlashKerning7 / 100)
		myCustomBeforeSlashKerning8 = (myCustomBeforeSlashKerning8 / 100)
		myCustomBeforeSlashKerning9 = (myCustomBeforeSlashKerning9 / 100)

		myCustomAfterSlashKerning0 = (myCustomAfterSlashKerning0 / 100)
		myCustomAfterSlashKerning1 = (myCustomAfterSlashKerning1 / 100)
		myCustomAfterSlashKerning2 = (myCustomAfterSlashKerning2 / 100)
		myCustomAfterSlashKerning3 = (myCustomAfterSlashKerning3 / 100)
		myCustomAfterSlashKerning4 = (myCustomAfterSlashKerning4 / 100)
		myCustomAfterSlashKerning5 = (myCustomAfterSlashKerning5 / 100)
		myCustomAfterSlashKerning6 = (myCustomAfterSlashKerning6 / 100)
		myCustomAfterSlashKerning7 = (myCustomAfterSlashKerning7 / 100)
		myCustomAfterSlashKerning8 = (myCustomAfterSlashKerning8 / 100)
		myCustomAfterSlashKerning9 = (myCustomAfterSlashKerning9 / 100)

		for(k=0; k<=9; k++) { //loop over the array for the character before the slash			
				if ( app.selection[0].characters.item(mySlashCharacterID - 1).contents == k ) {
					myProperFractionBeforeSlashKerning = ( myFoundSlashSize * eval("myCustomBeforeSlashKerning"+k)  )
					app.selection[0].characters.item(mySlashCharacterID - 1).kerningValue = myProperFractionBeforeSlashKerning
				}
			}
			for(kk=0; kk<=9; kk++) {  //loop over the array for the character after the slash 
				if ( app.selection[0].characters.item(mySlashCharacterID + 1).contents == kk ) {
					myProperFractionAfterSlashKerning = ( myFoundSlashSize * eval("myCustomAfterSlashKerning"+kk)  )
					app.selection[0].characters.item(mySlashCharacterID).kerningValue = myProperFractionAfterSlashKerning
				}
			}		
		}
		else {  //if they didn not select custom kerning, then use the blanket kerning amount
			//convert percents into decimals
			myNumeratorKern		= (myNumeratorKern / 100)    
			myDenominatorKern	= (myDenominatorKern / 100)
			//calculate amounts of kerning
			myProperFractionBeforeSlashKerning	= (myFoundSlashSize * myNumeratorKern)		//calculate the amount of kerning before the slash
			myProperFractionAfterSlashKerning	= (myFoundSlashSize * myDenominatorKern)	//calculate the amount of kerning after the slash
			//change the kerning around the slash
			app.selection[0].characters.item(mySlashCharacterID - 1).kerningValue = myProperFractionBeforeSlashKerning	//change kerning before slash
			app.selection[0].characters.item(mySlashCharacterID).kerningValue		= myProperFractionAfterSlashKerning	//change kerning afer the slash	
		}

	}
}